@php 
//Set variables for paypal form
$paypal_url = 'https://www.paypal.com/cgi-bin/webscr'; 
//Test PayPal API URL
$paypal_email = 'larry@staffshaw.com';
@endphp

<html>
    <head>
        <title>Payment Link Generator</title>
        <link href="{{ asset('public/sales/css/style.css') }}" type="text/css" rel="stylesheet">
        <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet" type="text/css">
    </head>
    <body>
        <header>
            <div class="top-bar">
                <img src="{{ asset('public/sales/images/logo.png') }}">
            </div>
        </header>
        
      
            <div class="container">
                
                <div class="row">
                    <div class="col-md-12 col-sm-12 col-lg-12 col-12">
                        <form action="{{ $paypal_url }}" method="post" id="payment-form" target="_blank">
                            <!-- Paypal business test account email id so that you can collect the payments. -->
                			<input type="hidden" name="business" value="<?php echo $paypal_email; ?>">			
                			<!-- Buy Now button. -->
                			<input type="hidden" name="cmd" value="_xclick">			
                			<!-- Details about the item that buyers will purchase. -->	
                            <div class="link-form">
                                <h2>Payment Link Generator</h2>
                                <label>Brand</label>
                                <select name="brand_id" id="brand-id">
                                    <option value="">Select Payment</option>
                                    @foreach($brands as $row)
                                    <option value="{{ $row->id }}">{{ $row->name }}</option>
                                    @endforeach
                                </select>
                                     
                                     
                                <label>Item Description</label>
                                <input type="text"  name="item_name" value="" placeholder="Item Description" id="item" required>
                                
                                <label>Amount Description</label>
                                <input type="text" name="amount" value="" placeholder="Amount Description" id="amount" required>
                                
                                <label>Payment Method</label>
                                <select name="payment_method" id="payment-method">
                                    <option value="">Select Payment</option>
                                    <option value="stripe">Stripe</option>
                                    <option value="paypal">Paypal</option>
                                </select>
                                
                                <input type="hidden" name="currency_code" value="GBP">			
                    			<!-- URLs -->
                    			<input type='hidden' name='cancel_return' value='http://localhost/paypal/cancel.php'>
                    			<input type='hidden' name='return' value='http://localhost/paypal/success.php'>				
                    			
                                <button class="payment-link-btn">Generate Link</button>
                                <div class="row mt-3">
                                    <div class="col-md-12" align="center">
                                        <div id="payment-link"></div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>

                      
                </div>
            
                
            </div>
        <script src="{{ asset('public/backend/js/vendors.bundle.js') }}"></script>
        <script src="{{ asset('public/backend/js/custom.js') }}"></script>
    </body>
</html>